import { View, Text, FlatList, StyleSheet } from "react-native";
import React from "react";
import BackNavigation from "../../../Utilities/CustomHeader/BackNavigation";
import { ProfileStyles } from "../../ProfileStyle";
import { orderHistoryStyle } from "../../OrderHistory/OrderHistoryStyle";
import { useSelector } from "react-redux";
import dpr from "../../../Utilities/CustomStyleAttribute/dpr";
import { useState } from "react";
import { useEffect } from "react";
import useAuth from "../../../../hooks/useAuth";
import { useDispatch } from "react-redux";
import { refresh } from "../../../../redux/slices/user/util/refresh";
import RefundListSkeleton from "../../../../src/skeletons/screens/profile/refund/RefundListSkeleton";
import { useRef } from "react";
import { refundStyle } from "../RefundRequest/RefundRequestStyle";
import { BASE_API_URL_STG } from "@env";
import SelectInput from "../../../../src/components/CustomInput/SelectInput/SelectInput";
import DownArrowFill from "../../../../assets/svgs/downArrowFill.svg";
import SelectItemBottomSheet from "../../../../src/components/SelectItemBottomSheet/SelectItemBottomSheet";
import SingleRefundList from "./SingleRefundList";
import { useMemo } from "react";
import CustomActiveIndicator from "../../../../src/components/CustomLoader/CustomActiveIndicator";
import {
    fetchRefundStart,
    getMoreRefunds,
    getMyRefunds,
    getMyRefundsSuccree,
} from "../../../../redux/slices/user/myRefund/getMyRefunds";
import useLangTranslation from "../../../../hooks/useLangTranslation";
import { txtSliceFmt } from "../../../../helper/txtSliceFmt";
import CustomSVG from "../../../../src/components/CustomSVG/CustomSVG";




const RefundList = (props) => {
    const { trans } = useLangTranslation();

    const dateFilter = [
        { name: trans("All Time"), value: "" },
        { name: trans("Today"), value: "today" },
        { name: trans("Last 7 days"), value: "last_week" },
        { name: trans("Last 30 Days"), value: "last_month" },
        { name: trans("Last 12 Month"), value: "last_year" },
    ];

    const statusFilter = [
        { name: trans("All Status"), value: "" },
        { name: trans("Opened"), value: "opened" },
        { name: trans("In Progress"), value: "in progress" },
        { name: trans("Accepted"), value: "accepted" },
        { name: trans("Declined"), value: "declined" },
    ];

    const { myRefunds, loading, isRefresh, nextPageUrl, loadMore } =
        useSelector((state) => state.getMyRefunds);
    const dateRef = useRef(null);
    const statusRef = useRef(null);
    const dispatch = useDispatch();
    const [date, setDate] = useState(dateFilter[0]);
    const [status, setStatus] = useState(statusFilter[0]);
    const { access_token } = useAuth();
    const [inFileLoading, setInFileLoading] = useState(true);
    const [loadBtmSheet, setLoadBtmSheet] = useState(false);
    useEffect(() => {
        setLoadBtmSheet(true);
    }, []);

    const refundUrl = `${BASE_API_URL_STG}/user/refunds`;
    useEffect(() => {
        if (date?.value && status?.value) {
            const URL = `${BASE_API_URL_STG}/user/refunds?status=${status?.value}&filter=${date?.value}`;
            dispatch(getMyRefunds({ access_token, URL }));
        } else if (date?.value && !status?.value) {
            const URL = `${BASE_API_URL_STG}/user/refunds?filter=${date?.value}`;
            dispatch(getMyRefunds({ access_token, URL }));
        } else if (!date?.value && status?.value) {
            const URL = `${BASE_API_URL_STG}/user/refunds?status=${status?.value}`;
            dispatch(getMyRefunds({ access_token, URL }));
        } else {
            dispatch(getMyRefunds({ access_token, URL: refundUrl }));
            access_token && setInFileLoading(false);
        }
    }, [status, date]);

    const handleLoadMoreRefund = () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            dispatch(getMoreRefunds({ access_token, URL: nextPageUrl }));
        }
        return () => {
            isMounted = false;
        };
    };

    const onRefresh = () => {
        refresh(
            access_token,
            `${refundUrl}`,
            dispatch,
            fetchRefundStart,
            getMyRefundsSuccree
        );
    };
    const memoizeOrder = useMemo(
        () =>
            ({ item }) =>
                <SingleRefundList item={item} />,
        []
    );
    let content = null;
    if (loading || inFileLoading) {
        content = <RefundListSkeleton />;
    }
    if (!loading && !inFileLoading && myRefunds?.length === 0) {
        content = (
            <FlatList
                refreshing={isRefresh}
                onRefresh={onRefresh}
                showsVerticalScrollIndicator={false}
                ListHeaderComponent={() => (
                    <View style={styles.noRefund}>
                        <Text style={styles.noRefundText}>
                            {trans("You Have No Refund Requests Yet")}
                        </Text>
                    </View>
                )}
            />
        );
    }
    if (!loading && !inFileLoading && myRefunds?.length > 0) {
        content = (
            <FlatList
                data={myRefunds}
                keyExtractor={(_, i) => "key-A" + i}
                renderItem={memoizeOrder}
                refreshing={isRefresh}
                onRefresh={onRefresh}
                showsVerticalScrollIndicator={false}
                initialNumToRender={10}
                windowSize={10}
                onEndReachedThreshold={1}
                onEndReached={handleLoadMoreRefund}
            />
        );
    }

    return (
        <View style={styles.container}>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans("refund list")}
                capitalize={true}
            />
            <View style={ProfileStyles.hrLine} />
            <View
                style={[
                    refundStyle.container,
                    refundStyle.contGap
                ]}
            >
                <View style={orderHistoryStyle.filterCont}>
                    <Text style={orderHistoryStyle.filterText}>
                        {txtSliceFmt(trans("Filter By"), 10)}
                    </Text>
                    <SelectInput
                        style={orderHistoryStyle.orderSelectInputCont}
                        placeholder={trans("All Time")}
                        onPress={() => dateRef.current?.snapToIndex(0)}
                        title={trans(date?.name)}
                        icon={<CustomSVG svgIcon={DownArrowFill} fill={"#2C2C2C"} />}
                    />
                    <SelectInput
                        style={orderHistoryStyle.orderSelectInputCont}
                        placeholder={trans("All Status")}
                        onPress={() => statusRef.current?.snapToIndex(0)}
                        title={trans(status?.name)}
                        icon={<CustomSVG svgIcon={DownArrowFill} fill={"#2C2C2C"} />}
                    />
                </View>
                {content}
            </View>
            {loadMore && <CustomActiveIndicator />}
            {loadBtmSheet && (
                <>
                    <SelectItemBottomSheet
                        snapPoint={[300]}
                        selectRef={dateRef}
                        data={dateFilter}
                        name={"Time"}
                        onPress={setDate}
                    />
                    <SelectItemBottomSheet
                        snapPoint={[300]}
                        selectRef={statusRef}
                        data={statusFilter}
                        name={"Status"}
                        onPress={setStatus}
                    />
                </>
            )}
        </View>
    );
};

export default RefundList;

const styles = StyleSheet.create({
    container: {
        flex: 1,
    },
    noRefund: {
        borderWidth: 1,
        borderColor: "#DFDFDF",
        borderRadius: 6,
        paddingHorizontal: dpr(54),
        paddingVertical: dpr(50),
        marginTop: dpr(20),
    },
    noRefundText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        color: "#898989",
        textAlign: "center",
        textAlign: "center",
        textAlignVertical: "center",
    },
});
